<?php
require_once 'load_data.php';
$allData = getAllData();
$jsonData = json_encode($allData, JSON_UNESCAPED_UNICODE);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SAE 303 - Temps de Parole des Femmes dans les Médias</title>
    
    <!-- Librairies -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/mathjs/11.11.0/math.min.js"></script>
    <script src="https://d3js.org/d3.v7.min.js"></script>
    
    <!-- Animation Glitch-->
    <script type="module">
      import GlitchEffect from './glitch-effect.js';
    </script>
    
    <!-- CSS TV Rétro -->
    <link rel="stylesheet" href="tv-retro.css">
     <link rel="stylesheet" href="tv-texture.css">
    <link rel="stylesheet" href="style.css">
    <link rel="stylesheet" href="artistic-mode.css">
    <link rel="stylesheet" href="tv-intro.css">
     <link rel="stylesheet" href="tv-outro.css">
     <link rel="stylesheet" href="navigation.css">
    <link rel="stylesheet" href="final-enhancements.css">
    
    <!-- Données -->
    <script>
        window.CSV_DATA = <?php echo $jsonData; ?>;
    </script>
</head>
<body>
    <!-- Barre de progression de défilement -->
    <div class="tv-progress-bar" id="tvProgressBar"></div>

    <!-- Container Principal TV Rétro -->
    <div class="tv-retro-container" id="tvRetroContainer">
        
        <!-- Cadre TV -->
        <div class="tv-frame">
            <div class="tv-screen">
                
                <!-- Effets CRT -->
                <div class="tv-scanlines"></div>
                <div class="tv-vignette"></div>
                <div class="tv-flicker"></div>
                <div class="tv-glow"></div>
                <div class="tv-curvature"></div>
                <div class="tv-scanline-bar"></div>
                
                <!-- En-tête TV & Horloge & CRT-->
                <div class="tv-top-status">
                    <!-- Bouton CRT ajouté ici -->
                    <button class="tv-toggle-crt active" id="tvToggleCRT">
                        <span class="led"></span>
                        CRT: ON
                    </button>
                    
                    <div class="crt-status">
                        <span class="led"></span>
                        CRT: ON
                    </div>
                    <div class="marquee-container">
                        <div class="tv-clock-marquee" id="tvClock">00:00:00</div>
                    </div>
                    
                 <!-- Indicateur de Mode -->
                <div class="tv-mode-indicator">
                    <button class="tv-mode-btn active" id="modeScientific">
                        <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M12 2v20M2 12h20"></path>
                            <circle cx="12" cy="12" r="9"></circle>
                        </svg>
                        Scientifique
                    </button>
                    <a href="artistic.php" class="tv-mode-btn" id="modeArtisticLink">
                        <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                            <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                        </svg>
                        Artistique
                    </a>
                </div>
                
            </div>
                
                <!-- Signal -->
                <div class="tv-signal">
                    <div class="tv-signal-bars">
                        <div class="signal-bar"></div>
                        <div class="signal-bar"></div>
                        <div class="signal-bar"></div>
                        <div class="signal-bar"></div>
                    </div>
                    <span>SIGNAL</span>
                </div>
                
                <!-- Header Principal -->
                <header class="tv-header">
                    <div class="tv-title">
                        <h1>Répartition du temps de parole des femmes par années et par chaînes
                            <span class="year-display" id="yearDisplay">
                                <span class="year" id="currentYear">2019</span>
                                <svg class="year-arrow" viewBox="0 0 24 24" width="18" height="18" fill="none" stroke="currentColor" stroke-width="2">
                                    <polyline points="6 9 12 15 18 9"></polyline>
                                </svg>
                            </span>
                        </h1>
                    </div>
                    
                    <!-- Dropdown Sélecteur d'Année -->
                    <div class="year-dropdown-container">
                        <div class="year-dropdown" id="yearDropdown">
                            <div class="year-dropdown-header">
                                <svg viewBox="0 0 24 24" width="16" height="16" fill="none" stroke="currentColor" stroke-width="2">
                                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"></rect>
                                    <line x1="16" y1="2" x2="16" y2="6"></line>
                                    <line x1="8" y1="2" x2="8" y2="6"></line>
                                    <line x1="3" y1="10" x2="21" y2="10"></line>
                                </svg>
                                <span>Sélectionner une année</span>
                            </div>
                            <div class="year-dropdown-options" id="yearDropdownOptions">
                                <!-- Les options seront générées par JavaScript -->
                            </div>
                        </div>
                    </div>
                    
                    <!-- Indicateurs statistiques -->
                    <div class="tv-stats">
                        <div class="tv-stat" data-tooltip="Variance des données">
                            <svg viewBox="0 0 24 24" width="14" height="14" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
                            </svg>
                            Variance
                        </div>
                        <div class="tv-stat" data-tooltip="Écart-type">
                            <svg viewBox="0 0 24 24" width="14" height="14" fill="none" stroke="currentColor" stroke-width="2">
                                <circle cx="12" cy="12" r="10"></circle>
                                <line x1="22" y1="12" x2="18" y2="12"></line>
                                <line x1="6" y1="12" x2="2" y2="12"></line>
                            </svg>
                            Écart-type
                        </div>
                        <div class="tv-stat" data-tooltip="Corrélation">
                            <svg viewBox="0 0 24 24" width="14" height="14" fill="none" stroke="currentColor" stroke-width="2">
                                <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
                            </svg>
                            Corrélation
                        </div>
                    </div>
            </header>
                
                <!-- Zone Graphique -->
                <div class="tv-chart-area" style="margin-top: 80px;">
                    <!-- Navigation Gauche -->
                    <button class="tv-nav-btn" id="chartLeft" title="Graphique précédent">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <polyline points="15 18 9 12 15 6"></polyline>
                        </svg>
                    </button>
                    
                    <!-- Container Graphique -->
                    <div class="tv-chart-container">
                        <canvas id="mainChart"></canvas>
                    </div>
                    
                    <!-- Navigation Droite -->
                    <button class="tv-nav-btn" id="chartRight" title="Graphique suivant">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <polyline points="9 18 15 12 9 6"></polyline>
                        </svg>
                    </button>
                </div>
                
                <!-- Légende -->
                <div class="tv-legend">
                    <div class="tv-legend-item">
                        <span class="tv-legend-dot male"></span>
                        Hommes
                    </div>
                    <div class="tv-legend-item">
                        <span class="tv-legend-dot female"></span>
                        Femmes
                    </div>
                </div>
                
                <!-- Barre de Métriques -->
                <div class="tv-metrics">
                    <div class="tv-metric">
                        <div class="tv-metric-trend down">- 23%</div>
                        <div class="tv-metric-value" id="variance">4,635</div>
                        <div class="tv-metric-label">Variance</div>
                    </div>
                    <div class="tv-metric">
                        <div class="tv-metric-trend down">- 9%</div>
                        <div class="tv-metric-value" id="stdDev">3.17</div>
                        <div class="tv-metric-label">Écart-type</div>
                    </div>
                    <div class="tv-metric">
                        <div class="tv-metric-trend up">+ 80%</div>
                        <div class="tv-metric-value" id="correlation">0.72</div>
                        <div class="tv-metric-label">Corrélation</div>
                    </div>
                    <div class="tv-metric">
                        <div class="tv-metric-trend up">+ 7%</div>
                        <div class="tv-metric-value" id="median">45.3%</div>
                        <div class="tv-metric-label">Médiane</div>
                    </div>
                </div>
                
            </div>
        </div>
        
        <!-- Compteur de Données -->
        <div class="tv-data-counter" id="tvDataCounter">
            DONNÉES <span>000</span>
        </div>
        
        
        <!-- Graphisme de défilement TV -->
        <div class="tv-scroll-graphic">
            <svg class="tv-scroll-icon up" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <polyline points="18 15 12 9 6 15"></polyline>
            </svg>
            <div class="tv-scroll-track">
                <div class="tv-scroll-position"></div>
            </div>
            <svg class="tv-scroll-icon down" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                <polyline points="6 9 12 15 18 9"></polyline>
            </svg>
            <div class="tv-scroll-counter">SCROLL</div>
        </div>
        
    </div>

    <!-- Sélecteur d'année (caché) -->
    <select id="yearFilter" style="display:none;">
        <?php
        $yearsData = getYearsData();
        foreach ($yearsData['years'] as $year) {
            $selected = ($year == '2019') ? 'selected' : '';
            echo "<option value='$year' $selected>$year</option>";
        }
        ?>
    </select>

    <!-- Scripts -->
    <script src="tv-graphics.js"></script>
    <script src="main-chart.js"></script>
    <script src="tv-intro.js"></script>
    <script src="tv-outro.js"></script>
    
    <script>
        // Mise à jour de l'année
        document.getElementById('yearDisplay').addEventListener('click', function(e) {
            e.stopPropagation();
            const dropdown = document.getElementById('yearDropdown');
            const yearRect = this.getBoundingClientRect();
            
            // Positionner le dropdown directement sous l'élément cliqué avec position fixed
            dropdown.style.top = (yearRect.bottom + 8) + 'px';
            dropdown.style.left = yearRect.left + 'px';
            dropdown.style.right = 'auto';
            
            dropdown.classList.toggle('open');
        });
        
        // Empêcher la propagation des clics dans le dropdown
        document.getElementById('yearDropdown').addEventListener('click', function(e) {
            e.stopPropagation();
        });
        
        // Fermer le dropdown si on clique ailleurs
        document.addEventListener('click', function(e) {
            const dropdown = document.getElementById('yearDropdown');
            const display = document.getElementById('yearDisplay');
            if (!dropdown.contains(e.target) && !display.contains(e.target)) {
                dropdown.classList.remove('open');
            }
        });
        
        // Générer les options du dropdown
        function generateYearDropdown() {
            const yearFilter = document.getElementById('yearFilter');
            const optionsContainer = document.getElementById('yearDropdownOptions');
            
            if (yearFilter && optionsContainer) {
                const options = yearFilter.options;
                const currentYear = yearFilter.value;
                
                for (let i = 0; i < options.length; i++) {
                    const option = document.createElement('div');
                    option.className = 'year-option' + (options[i].value === currentYear ? ' active' : '');
                    option.textContent = options[i].value;
                    option.dataset.year = options[i].value;
                    
                    option.addEventListener('click', function() {
                        selectYear(options[i].value);
                        
                        // Fermer le dropdown
                        document.getElementById('yearDropdown').classList.remove('open');
                    });
                    
                    optionsContainer.appendChild(option);
                }
            }
        }
        
        // Fonction pour sélectionner une année
        function selectYear(year) {
            const yearFilter = document.getElementById('yearFilter');
            if (yearFilter) {
                yearFilter.value = year;
                
                // Mettre à jour l'affichage de l'année avec animation
                const currentYearEl = document.getElementById('currentYear');
                currentYearEl.style.opacity = '0';
                currentYearEl.style.transform = 'translateY(-10px)';
                
                setTimeout(() => {
                    currentYearEl.textContent = year;
                    currentYearEl.style.opacity = '1';
                    currentYearEl.style.transform = 'translateY(0)';
                }, 150);
                
                // Mettre à jour les options actives
                const options = document.querySelectorAll('.year-option');
                options.forEach(opt => {
                    opt.classList.toggle('active', opt.dataset.year === year);
                });
                
                // Mettre à jour le graphique
                if (typeof initMainChart === 'function') {
                    initMainChart();
                }
                
                // Mettre à jour les stats
                if (typeof updateMathematicalStats === 'function') {
                    updateMathematicalStats(year);
                }
            }
        }
        
        // Initialiser le dropdown après le chargement
        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(generateYearDropdown, 500);
        });
        
        // ========================================
        // SCROLL GRAPHIC FONCTIONNEL
        // ========================================
        function initScrollGraphic() {
            const scrollGraphic = document.querySelector('.tv-scroll-graphic');
            const scrollPosition = document.querySelector('.tv-scroll-position');
            const scrollCounter = document.querySelector('.tv-scroll-counter');
            const scrollUp = document.querySelector('.tv-scroll-icon.up');
            const scrollDown = document.querySelector('.tv-scroll-icon.down');
            
            if (!scrollGraphic || !scrollPosition) return;
            
            // Obtenir la hauteur de la page
            const docHeight = document.documentElement.scrollHeight - window.innerHeight;
            let scrollPercent = 0;
            
            // Fonction de mise à jour de la position du scroll
            function updateScrollPosition() {
                scrollPercent = (window.scrollY / docHeight) * 100;
                scrollPercent = Math.max(0, Math.min(100, scrollPercent));
                
                if (scrollPosition) {
                    scrollPosition.style.height = scrollPercent + '%';
                    scrollPosition.style.top = '0';
                }
                
                if (scrollCounter) {
                    const scrollValue = Math.round(scrollPercent);
                    scrollCounter.textContent = scrollValue.toString().padStart(3, '0');
                }
            }
            
            // Gestion du scroll de la page
            window.addEventListener('scroll', function() {
                updateScrollPosition();
            });
            
            // Clic sur le track pour aller à cette position
            scrollGraphic.addEventListener('click', function(e) {
                const rect = scrollGraphic.getBoundingClientRect();
                const clickY = e.clientY - rect.top;
                const clickPercent = clickY / rect.height;
                const targetScroll = clickPercent * docHeight;
                
                window.scrollTo({
                    top: targetScroll,
                    behavior: 'smooth'
                });
            });
            
            // Navigation avec les icônes
            if (scrollUp) {
                scrollUp.addEventListener('click', function(e) {
                    e.stopPropagation();
                    window.scrollBy({
                        top: -window.innerHeight * 0.8,
                        behavior: 'smooth'
                    });
                });
            }
            
            if (scrollDown) {
                scrollDown.addEventListener('click', function(e) {
                    e.stopPropagation();
                    window.scrollBy({
                        top: window.innerHeight * 0.8,
                        behavior: 'smooth'
                    });
                });
            }
            
            // Initialiser la position
            updateScrollPosition();
        }
        
        // Initialiser le scroll graphic
        document.addEventListener('DOMContentLoaded', function() {
            initScrollGraphic();
        });
    </script>

    
</body>
</html>

